"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChamadoController = void 0;
const common_1 = require("@nestjs/common");
const chamado_service_1 = require("./chamado.service");
const user_entity_1 = require("../user/entities/user.entity");
const platform_express_1 = require("@nestjs/platform-express");
const current_user_decorator_1 = require("../auth/decorators/current-user.decorator");
const user_role_enum_1 = require("../user/user-role.enum");
const passport_1 = require("@nestjs/passport");
const roles_guard_1 = require("../auth/guards/roles.guard");
let ChamadoController = class ChamadoController {
    chamadoService;
    constructor(chamadoService) {
        this.chamadoService = chamadoService;
    }
    async abrirChamado(data, equipamentoId, currentUser, files) {
        const createChamadoDto = JSON.parse(data);
        return this.chamadoService.abrir(createChamadoDto, equipamentoId, currentUser, files);
    }
    async assinarChamado(chamadoId, currentUser, body) {
        return this.chamadoService.assinarChamado(+chamadoId, currentUser, body.assinatura);
    }
    atribuirTecnico(tecnicoID, chamadoID, data) {
        return this.chamadoService.atribuirTecnico(chamadoID, tecnicoID, data.date);
    }
    async atualizarPorCheck(equipamentoId, data, currentUser, files) {
        const createChamadoDto = JSON.parse(data);
        return this.chamadoService.atualizarPorCheck(equipamentoId, createChamadoDto, currentUser, files);
    }
    async finalizarChamado(equipamentoId, CurrentUser, ResumoData) {
        return this.chamadoService.finalizarChamado(equipamentoId, CurrentUser, ResumoData);
    }
    async itensModal(equipamentoId) {
        return this.chamadoService.itensModal(equipamentoId);
    }
    async getCheckListTeck(equipamentoId) {
        return this.chamadoService.getCheckListTeck(equipamentoId);
    }
    async detalhesOsCliente(currentUser, osId) {
        const detalhes = await this.chamadoService.detalhesOsCliente(currentUser, osId);
        const timeLine = await this.chamadoService.timeLine(currentUser, osId);
        return { detalhes: detalhes, timeLine: timeLine };
    }
    findAll(currentUser) {
        return this.chamadoService.findAllChamados(currentUser);
    }
    findOne(id) {
        return this.chamadoService.findOne(+id);
    }
    findAllOfUser(userId) {
        return this.chamadoService.findAllOfUser(+userId);
    }
    remove(id) {
        return this.chamadoService.deletarOs(+id);
    }
};
exports.ChamadoController = ChamadoController;
__decorate([
    (0, common_1.Post)(':equipamentoId'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('files', 5)),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.COMMON_USER, user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, common_1.Body)('data')),
    __param(1, (0, common_1.Param)('equipamentoId')),
    __param(2, (0, current_user_decorator_1.CurrentUser)()),
    __param(3, (0, common_1.UploadedFiles)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, user_entity_1.User, Array]),
    __metadata("design:returntype", Promise)
], ChamadoController.prototype, "abrirChamado", null);
__decorate([
    (0, common_1.Post)(':id/assinar'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.COMMON_USER),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, user_entity_1.User, Object]),
    __metadata("design:returntype", Promise)
], ChamadoController.prototype, "assinarChamado", null);
__decorate([
    (0, common_1.Post)('atribuir-tecnico/tecnico/:tecnicoID/chamado/:chamadoID'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Param)('tecnicoID', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Param)('chamadoID', common_1.ParseIntPipe)),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Object]),
    __metadata("design:returntype", void 0)
], ChamadoController.prototype, "atribuirTecnico", null);
__decorate([
    (0, common_1.Patch)('atualizar-por-check/equipamento/:equipamentoId'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('files', 5)),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, common_1.Param)('equipamentoId', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Body)('data')),
    __param(2, (0, current_user_decorator_1.CurrentUser)()),
    __param(3, (0, common_1.UploadedFiles)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, user_entity_1.User, Array]),
    __metadata("design:returntype", Promise)
], ChamadoController.prototype, "atualizarPorCheck", null);
__decorate([
    (0, common_1.Patch)('/finalizar/equipamento/:equipamentoId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, common_1.Param)('equipamentoId', common_1.ParseIntPipe)),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __param(2, (0, common_1.Body)('ResumoData')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, user_entity_1.User, String]),
    __metadata("design:returntype", Promise)
], ChamadoController.prototype, "finalizarChamado", null);
__decorate([
    (0, common_1.Get)('itens-modal/equipamento/:equipamentoId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, common_1.Param)('equipamentoId', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ChamadoController.prototype, "itensModal", null);
__decorate([
    (0, common_1.Get)('checklisttec/:equipamentoId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, common_1.Param)('equipamentoId', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ChamadoController.prototype, "getCheckListTeck", null);
__decorate([
    (0, common_1.Get)('detalhes/:osId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.COMMON_USER, user_role_enum_1.UserRole.TECHNICAL, user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_1.Param)('osId', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User, Number]),
    __metadata("design:returntype", Promise)
], ChamadoController.prototype, "detalhesOsCliente", null);
__decorate([
    (0, common_1.Get)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN, user_role_enum_1.UserRole.COMMON_USER, user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", void 0)
], ChamadoController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ChamadoController.prototype, "findOne", null);
__decorate([
    (0, common_1.Get)('cliente/:userId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ChamadoController.prototype, "findAllOfUser", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ChamadoController.prototype, "remove", null);
exports.ChamadoController = ChamadoController = __decorate([
    (0, common_1.Controller)('chamado'),
    __metadata("design:paramtypes", [chamado_service_1.ChamadoService])
], ChamadoController);
//# sourceMappingURL=chamado.controller.js.map