"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const chamado_entity_1 = require("../chamado/entities/chamado.entity");
const equipamento_entity_1 = require("../equipamento/entities/equipamento.entity");
const resposta_checklist_entity_1 = require("../chamado/entities/resposta-checklist.entity");
const user_entity_1 = require("../user/entities/user.entity");
const equipamento_role_enum_1 = require("../equipamento/equipamento-role.enum");
const resposta_checklist_tecnico_entity_1 = require("../chamado/entities/resposta-checklist-tecnico.entity");
const dayjs_1 = __importDefault(require("dayjs"));
const user_role_enum_1 = require("../user/user-role.enum");
let DashboardService = class DashboardService {
    chamadoRepository;
    equipamentoRepository;
    respostaChecklistRepository;
    userRepository;
    respostaChecklistTecnicoRepository;
    constructor(chamadoRepository, equipamentoRepository, respostaChecklistRepository, userRepository, respostaChecklistTecnicoRepository) {
        this.chamadoRepository = chamadoRepository;
        this.equipamentoRepository = equipamentoRepository;
        this.respostaChecklistRepository = respostaChecklistRepository;
        this.userRepository = userRepository;
        this.respostaChecklistTecnicoRepository = respostaChecklistTecnicoRepository;
    }
    async CountEquipament(currentUser) {
        const statusCounts = await this.equipamentoRepository
            .createQueryBuilder('equipamento')
            .select('equipamento.status', 'status')
            .addSelect('COUNT(*)', 'count')
            .where('equipamento.status IN (:...statuses) AND equipamento.userId = :userId', {
            statuses: [
                equipamento_role_enum_1.EquipamentoStatus.DISPONIVEL,
                equipamento_role_enum_1.EquipamentoStatus.MANUTENCAO,
            ],
            userId: currentUser.id,
        })
            .groupBy('equipamento.status')
            .getRawMany();
        const result = {
            equipamentosDisponiveis: 0,
            equipamentosEmManutencao: 0,
        };
        for (const item of statusCounts) {
            if (item.status === equipamento_role_enum_1.EquipamentoStatus.DISPONIVEL) {
                result.equipamentosDisponiveis = parseInt(item.count, 10);
            }
            else if (item.status === equipamento_role_enum_1.EquipamentoStatus.MANUTENCAO) {
                result.equipamentosEmManutencao = parseInt(item.count, 10);
            }
        }
        return result;
    }
    async chamadosPendentes(currentUser) {
        const chamados = await this.chamadoRepository
            .createQueryBuilder('chamado')
            .leftJoin('chamado.equipamento', 'equipamento')
            .where('chamado.userId = :userId', { userId: currentUser.id })
            .andWhere('chamado.status IN (:...statuses)', {
            statuses: ['Aberto', 'Em andamento'],
        })
            .select('chamado.id', 'id_chamado')
            .addSelect('chamado.status', 'status')
            .addSelect('equipamento.modeloCompressor', 'modeloCompressor')
            .addSelect('equipamento.id', 'equipamentoId')
            .getRawMany();
        return chamados;
    }
    async typeChamado(currentUser) {
        const months = [
            {
                name: (0, dayjs_1.default)().format('MMMM'),
                start: (0, dayjs_1.default)().startOf('month').toDate(),
                end: (0, dayjs_1.default)().endOf('month').toDate(),
            },
            {
                name: (0, dayjs_1.default)().subtract(1, 'month').format('MMMM'),
                start: (0, dayjs_1.default)().subtract(1, 'month').startOf('month').toDate(),
                end: (0, dayjs_1.default)().subtract(1, 'month').endOf('month').toDate(),
            },
            {
                name: (0, dayjs_1.default)().subtract(2, 'month').format('MMMM'),
                start: (0, dayjs_1.default)().subtract(2, 'month').startOf('month').toDate(),
                end: (0, dayjs_1.default)().subtract(2, 'month').endOf('month').toDate(),
            },
        ];
        const results = [];
        for (const month of months) {
            const tipoCounts = await this.chamadoRepository
                .createQueryBuilder('chamado')
                .where('chamado.userId = :userId', { userId: currentUser.id })
                .andWhere('chamado.status IN (:...statuses)', {
                statuses: ['Finalizado', 'Em andamento'],
            })
                .andWhere('chamado.horaFinalizacao BETWEEN :start AND :end', {
                start: month.start,
                end: month.end,
            })
                .select('chamado.tipo', 'tipo')
                .addSelect('COUNT(*)', 'count')
                .groupBy('chamado.tipo')
                .getRawMany();
            const operacional = await this.respostaChecklistTecnicoRepository
                .createQueryBuilder('respostaChecklistTecnico')
                .leftJoin('respostaChecklistTecnico.chamado', 'chamado')
                .where('respostaChecklistTecnico.operacional = :operacional', {
                operacional: true,
            })
                .andWhere('chamado.userId = :userId', { userId: currentUser.id })
                .andWhere('chamado.status IN (:...statuses)', {
                statuses: ['Finalizado', 'Em andamento'],
            })
                .andWhere('chamado.horaFinalizacao BETWEEN :start AND :end', {
                start: month.start,
                end: month.end,
            })
                .select('COUNT(DISTINCT chamado.id)', 'count')
                .getRawOne();
            const monthResult = {
                month: month.name,
                corretivo: 0,
                preventivo: 0,
                operacional: operacional ? parseInt(operacional.count, 10) : 0,
            };
            for (const item of tipoCounts) {
                if (item.tipo === 'Corretivo') {
                    monthResult.corretivo = parseInt(item.count, 10);
                }
                else if (item.tipo === 'Preventiva') {
                    monthResult.preventivo = parseInt(item.count, 10);
                }
            }
            results.push(monthResult);
        }
        return results;
    }
    async atividadeTecnicoEsseMes() {
        const startOfMonth = (0, dayjs_1.default)().startOf('month').toDate();
        const endOfMonth = (0, dayjs_1.default)().endOf('month').toDate();
        const rawTecnicos = await this.chamadoRepository
            .createQueryBuilder('chamado')
            .leftJoin('chamado.tecnico', 'tecnico')
            .where('tecnico.role = :role', { role: user_role_enum_1.UserRole.TECHNICAL })
            .andWhere('( (chamado.status = :finalizado AND chamado.horaFinalizacao BETWEEN :start AND :end) OR (chamado.status = :emAndamento AND chamado.horaAbertura BETWEEN :start AND :end) )', {
            finalizado: 'Finalizado',
            emAndamento: 'Em andamento',
            start: startOfMonth,
            end: endOfMonth,
        })
            .select('tecnico.name', 'name')
            .addSelect("SUM(CASE WHEN chamado.status = 'Finalizado' THEN 1 ELSE 0 END)", 'finalizados')
            .addSelect("SUM(CASE WHEN chamado.status = 'Em andamento' THEN 1 ELSE 0 END)", 'emAndamento')
            .groupBy('tecnico.name')
            .orderBy('name', 'ASC')
            .getRawMany();
        const tecnicosComTaxa = rawTecnicos.map((tec) => {
            const finalizados = parseInt(tec.finalizados, 10) || 0;
            const emAndamento = parseInt(tec.emAndamento, 10) || 0;
            const total = finalizados + emAndamento;
            const taxaAcerto = total > 0 ? finalizados / total : 0;
            return {
                name: tec.name,
                finalizados: finalizados,
                emAndamento: emAndamento,
                total: total,
                taxaSucesso: (taxaAcerto * 100).toFixed(2),
            };
        });
        return tecnicosComTaxa;
    }
    async atividadeTecnicoSeisMeses() {
        const months = [
            {
                name: (0, dayjs_1.default)().format('MMMM'),
                start: (0, dayjs_1.default)().startOf('month').toDate(),
                end: (0, dayjs_1.default)().endOf('month').toDate(),
            },
            {
                name: (0, dayjs_1.default)().subtract(1, 'month').format('MMMM'),
                start: (0, dayjs_1.default)().subtract(1, 'month').startOf('month').toDate(),
                end: (0, dayjs_1.default)().subtract(1, 'month').endOf('month').toDate(),
            },
            {
                name: (0, dayjs_1.default)().subtract(2, 'month').format('MMMM'),
                start: (0, dayjs_1.default)().subtract(2, 'month').startOf('month').toDate(),
                end: (0, dayjs_1.default)().subtract(2, 'month').endOf('month').toDate(),
            },
            {
                name: (0, dayjs_1.default)().subtract(3, 'month').format('MMMM'),
                start: (0, dayjs_1.default)().subtract(3, 'month').startOf('month').toDate(),
                end: (0, dayjs_1.default)().subtract(3, 'month').endOf('month').toDate(),
            },
            {
                name: (0, dayjs_1.default)().subtract(4, 'month').format('MMMM'),
                start: (0, dayjs_1.default)().subtract(4, 'month').startOf('month').toDate(),
                end: (0, dayjs_1.default)().subtract(4, 'month').endOf('month').toDate(),
            },
            {
                name: (0, dayjs_1.default)().subtract(5, 'month').format('MMMM'),
                start: (0, dayjs_1.default)().subtract(5, 'month').startOf('month').toDate(),
                end: (0, dayjs_1.default)().subtract(5, 'month').endOf('month').toDate(),
            },
        ];
        const results = [];
        for (const month of months) {
            const tecnicos = await this.chamadoRepository
                .createQueryBuilder('chamado')
                .leftJoin('chamado.tecnico', 'tecnico')
                .where('chamado.status IN (:...statuses)', {
                statuses: ['Finalizado', 'Em andamento'],
            })
                .andWhere('chamado.horaFinalizacao BETWEEN :start AND :end', {
                start: month.start,
                end: month.end,
            })
                .select('chamado.tipo', 'tipo')
                .addSelect('COUNT(*)', 'count')
                .groupBy('chamado.tipo')
                .getRawMany();
            const operacional = await this.respostaChecklistTecnicoRepository
                .createQueryBuilder('respostaChecklistTecnico')
                .leftJoin('respostaChecklistTecnico.chamado', 'chamado')
                .where('respostaChecklistTecnico.operacional = :operacional', {
                operacional: true,
            })
                .andWhere('chamado.status IN (:...statuses)', {
                statuses: ['Finalizado', 'Em andamento'],
            })
                .andWhere('chamado.horaFinalizacao BETWEEN :start AND :end', {
                start: month.start,
                end: month.end,
            })
                .select('COUNT(DISTINCT chamado.id)', 'count')
                .getRawOne();
            const monthResult = {
                month: month.name,
                corretivo: 0,
                preventivo: 0,
                operacional: operacional ? parseInt(operacional.count, 10) : 0,
            };
            for (const item of tecnicos) {
                if (item.tipo === 'Corretivo') {
                    monthResult.corretivo = parseInt(item.count, 10);
                }
                else if (item.tipo === 'Preventiva') {
                    monthResult.preventivo = parseInt(item.count, 10);
                }
            }
            results.push(monthResult);
        }
        return results;
    }
    async osPendente() {
        const osPendentes = await this.chamadoRepository
            .createQueryBuilder('chamado')
            .leftJoin('chamado.equipamento', 'equipamento')
            .leftJoin('chamado.user', 'user')
            .leftJoin('chamado.tecnico', 'tecnico')
            .where('chamado.status IN (:...statuses)', {
            statuses: ['Pendente', 'Aberto'],
        })
            .select('chamado.id', 'id')
            .addSelect('chamado.status', 'status')
            .addSelect('chamado.horaAbertura', 'horaAbertura')
            .addSelect('user.name', 'name')
            .addSelect('tecnico.name', 'tecnico')
            .addSelect('tecnico.id', 'tecnicoId')
            .getRawMany();
        return osPendentes;
    }
    async totalCliente() {
        const total = await this.userRepository.count({
            where: { role: user_role_enum_1.UserRole.COMMON_USER },
        });
        return total;
    }
    async totalTecnico() {
        const total = await this.userRepository.count({
            where: { role: user_role_enum_1.UserRole.TECHNICAL },
        });
        return total;
    }
    async totalOsPendente() {
        const total = await this.chamadoRepository.count({
            where: { status: (0, typeorm_1.In)(['Pendente', 'Aberto']) },
        });
        return total;
    }
    async totalEquipamentosMonitorados() {
        const total = await this.chamadoRepository.count({
            where: { status: 'Finalizado' },
        });
        return total;
    }
    async chamadoPorTipoDeEquipamento() {
        const startOfMonth = (0, dayjs_1.default)().startOf('month').toDate();
        const endOfMonth = (0, dayjs_1.default)().endOf('month').toDate();
        const chamados = await this.chamadoRepository
            .createQueryBuilder('chamado')
            .leftJoin('chamado.equipamento', 'equipamento')
            .where('chamado.status IN (:...statuses)', {
            statuses: ['Finalizado', 'Em andamento'],
        })
            .andWhere(`((chamado.status = 'Finalizado' AND chamado.horaFinalizacao BETWEEN :start AND :end) OR
        (chamado.status = 'Em andamento' AND chamado.horaAbertura BETWEEN :start AND :end))`, { start: startOfMonth, end: endOfMonth })
            .select('equipamento.modeloCompressor', 'modeloCompressor')
            .addSelect('COUNT(*)', 'total_chamados')
            .groupBy('equipamento.modeloCompressor')
            .getRawMany();
        return chamados;
    }
    async atividadeTecnicoSeteDias(currentUser) {
        const results = [];
        for (let i = 6; i >= 0; i--) {
            const date = (0, dayjs_1.default)().subtract(i, 'day');
            const startOfDay = date.startOf('day').toDate();
            const endOfDay = date.endOf('day').toDate();
            const dailyStats = await this.chamadoRepository
                .createQueryBuilder('chamado')
                .select("SUM(CASE WHEN chamado.status = 'Finalizado' THEN 1 ELSE 0 END)", 'finalizados')
                .addSelect("SUM(CASE WHEN chamado.status = 'Pendente' OR chamado.status = 'Em andamento' THEN 1 ELSE 0 END)", 'pendentes')
                .where('chamado.tecnicoId = :tecnicoId', { tecnicoId: currentUser.id })
                .andWhere('( (chamado.status = :finalizado AND chamado.horaFinalizacao BETWEEN :start AND :end) OR ( (chamado.status = :pendente OR chamado.status = :emAndamento) AND chamado.horaAbertura BETWEEN :start AND :end) )', {
                finalizado: 'Finalizado',
                pendente: 'Pendente',
                emAndamento: 'Em andamento',
                start: startOfDay,
                end: endOfDay,
            })
                .getRawOne();
            results.push({
                date: date.format('YYYY-MM-DD'),
                finalizados: (dailyStats && parseInt(dailyStats.finalizados, 10)) || 0,
                pendentes: (dailyStats && parseInt(dailyStats.pendentes, 10)) || 0,
            });
        }
        return results;
    }
    async maquinasTecnico(currentUser) {
        const chamado = await this.chamadoRepository
            .createQueryBuilder('chamado')
            .leftJoin('chamado.equipamento', 'equipamento')
            .leftJoin('chamado.user', 'user')
            .where('chamado.tecnicoId = :tecnicoId', { tecnicoId: currentUser.id })
            .andWhere('chamado.status IN (:...statuses)', {
            statuses: ['Pendente', 'Em andamento'],
        })
            .select('equipamento.modeloCompressor', 'modeloCompressor')
            .addSelect('equipamento.id', 'equipamentoId')
            .addSelect('chamado.tipo', 'tipo')
            .addSelect('chamado.status', 'status')
            .addSelect('chamado.id', 'id')
            .addSelect('chamado.horaAbertura', 'horaAbertura')
            .addSelect('user.name', 'name')
            .orderBy('chamado.horaAbertura', 'ASC')
            .getRawMany();
        return chamado;
    }
    async atividadeRecente(currentUser) {
        const chamado = await this.chamadoRepository
            .createQueryBuilder('chamado')
            .leftJoin('chamado.equipamento', 'equipamento')
            .leftJoin('chamado.user', 'user')
            .leftJoin('chamado.tecnico', 'tecnico')
            .where('chamado.tecnicoId = :tecnicoId', { tecnicoId: currentUser.id })
            .andWhere('chamado.status IN (:...statuses)', {
            statuses: ['Pendente', 'Em andamento'],
        })
            .select('equipamento.modeloCompressor', 'modeloCompressor')
            .addSelect('chamado.tipo', 'tipo')
            .addSelect('chamado.status', 'status')
            .addSelect('chamado.id', 'id')
            .addSelect('chamado.horaAbertura', 'horaAbertura')
            .addSelect('user.name', 'usuario')
            .addSelect('tecnico.name', 'tecnico')
            .orderBy('chamado.horaAbertura', 'ASC')
            .getRawMany();
        return chamado;
    }
};
exports.DashboardService = DashboardService;
exports.DashboardService = DashboardService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(chamado_entity_1.Chamado)),
    __param(1, (0, typeorm_2.InjectRepository)(equipamento_entity_1.Equipamento)),
    __param(2, (0, typeorm_2.InjectRepository)(resposta_checklist_entity_1.RespostaChecklist)),
    __param(3, (0, typeorm_2.InjectRepository)(user_entity_1.User)),
    __param(4, (0, typeorm_2.InjectRepository)(resposta_checklist_tecnico_entity_1.RespostaChecklistTecnico)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository])
], DashboardService);
//# sourceMappingURL=dashboard.service.js.map