import { EquipamentoService } from './equipamento.service';
import { CreateEquipamentoDto } from './dto/create-equipamento.dto';
import { UpdateEquipamentoDto } from './dto/update-equipamento.dto';
import { User } from 'src/user/entities/user.entity';
import type { Response } from 'express';
export declare class EquipamentoController {
    private readonly equipamentoService;
    constructor(equipamentoService: EquipamentoService);
    create(createEquipamentoDto: CreateEquipamentoDto): Promise<import("./entities/equipamento.entity").Equipamento>;
    findAll(currentUser: User): Promise<import("./entities/equipamento.entity").Equipamento[] | undefined>;
    findOne(id: string): Promise<{
        chamadoAberto: {
            id: number | undefined;
            horaAtendimento: Date | undefined;
            horaFinalizacao: Date | undefined;
        };
        chamadosFechados: {
            id: number;
            tipo: string;
            status: string;
            horaAbertura: Date;
            horaInicioAtendimento: Date;
            horaFinalizacao: Date;
            tecnico: {
                name: string;
            } | null;
        }[];
        id: number;
        modeloCompressor: string;
        tipoGas: string;
        tipoOleo: string;
        tipoEvaporador: string;
        tipoCondensador: string;
        tipoValvula: string;
        tensao: string;
        aplicacao: string;
        qrcode: string;
        isAtivo: boolean;
        status: import("./equipamento-role.enum").EquipamentoStatus;
        user: User | null;
        visitas: import("../colaborador/entities/visitaAgendada.entity").VisitaAgendada[];
    }>;
    findByUser(userid: string): Promise<import("./entities/equipamento.entity").Equipamento[]>;
    updateRealTime(id: string): Promise<import("../chamado/entities/resposta-checklist-tecnico.entity").RespostaChecklistTecnico[]>;
    generateQRCode(id: string, res: Response): Promise<void>;
    historico(id: string, correntUser: User): Promise<import("../chamado/entities/chamado.entity").Chamado[]>;
    update(id: string, updateEquipamentoDto: UpdateEquipamentoDto): Promise<import("typeorm").UpdateResult>;
    ativar(id: string): Promise<void>;
    desativar(id: string): Promise<void>;
    remove(id: string): Promise<import("typeorm").DeleteResult>;
}
