"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var NotificacaoListener_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificacaoListener = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const chamado_entity_1 = require("../chamado/entities/chamado.entity");
const config_1 = require("@nestjs/config");
const user_entity_1 = require("../user/entities/user.entity");
let NotificacaoListener = NotificacaoListener_1 = class NotificacaoListener {
    configService;
    logger = new common_1.Logger(NotificacaoListener_1.name);
    GZAPPY_TOKEN;
    GZAPPY_CELL;
    constructor(configService) {
        this.configService = configService;
        this.GZAPPY_TOKEN = this.configService.get('GZAPPY_TOKEN');
        if (!this.GZAPPY_TOKEN) {
            this.logger.warn('GZAPPY_TOKEN não está configurado. As notificações não serão enviadas.');
        }
        this.GZAPPY_CELL = this.configService.get('GZAPPY_CELL');
    }
    async handleChamadoAbertoEvent(chamado, user) {
        this.logger.log(`NOTIFICANDO WHATSAPP: Novo chamado #${chamado.id} aberto.`);
        if (!this.GZAPPY_TOKEN)
            return;
        const fetch = (await import('node-fetch')).default;
        try {
            const response = await fetch('https://v2-api.gzappy.com/message/send-text', {
                method: 'POST',
                headers: {
                    'Authorization': `Bearer ${this.GZAPPY_TOKEN}`,
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    phone: this.GZAPPY_CELL,
                    message: `Olá, ${user.name}!
Recebemos sua solicitação de manutenção. Nossa equipe já está ciente e fará a triagem do problema.
Chamado: #[ID do Chamado] Equipamento: [Nome/ID do Equipamento] Status: Pendente
Manteremos você informado por aqui sobre os próximos passos.
Atenciosamente, Equipe MGR Refrigeração`
                })
            });
            const data = await response.json();
            this.logger.log('Mensagem enviada com sucesso:', data);
        }
        catch (error) {
            this.logger.error('Erro ao enviar mensagem via GZappy:', error);
        }
    }
};
exports.NotificacaoListener = NotificacaoListener;
__decorate([
    (0, event_emitter_1.OnEvent)('chamado.Aberto'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [chamado_entity_1.Chamado, user_entity_1.User]),
    __metadata("design:returntype", Promise)
], NotificacaoListener.prototype, "handleChamadoAbertoEvent", null);
exports.NotificacaoListener = NotificacaoListener = NotificacaoListener_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], NotificacaoListener);
//# sourceMappingURL=notificacao.listener.js.map