"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const typeorm_1 = require("typeorm");
const user_role_enum_1 = require("../user-role.enum");
const equipamento_entity_1 = require("../../equipamento/entities/equipamento.entity");
const chamado_entity_1 = require("../../chamado/entities/chamado.entity");
const colaborador_entity_1 = require("../../colaborador/entities/colaborador.entity");
const registroColaborador_entity_1 = require("../../colaborador/entities/registroColaborador.entity");
const despesas_entity_1 = require("../../colaborador/entities/despesas.entity");
let User = class User {
    id;
    name;
    email;
    password;
    cnpj;
    razaoSocial;
    telefone;
    isActive;
    role;
    requiresSubscription;
    workDays;
    workShiftStart;
    workShiftEnd;
    registrationDate;
    equipamentos;
    chamados;
    registrosColaborador;
    colaboradoresDaEmpresa;
    despesas;
};
exports.User = User;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], User.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], User.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)({ unique: true }),
    __metadata("design:type", String)
], User.prototype, "email", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], User.prototype, "password", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], User.prototype, "cnpj", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], User.prototype, "razaoSocial", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], User.prototype, "telefone", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: true }),
    __metadata("design:type", Boolean)
], User.prototype, "isActive", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: user_role_enum_1.UserRole, default: user_role_enum_1.UserRole.COMMON_USER }),
    __metadata("design:type", String)
], User.prototype, "role", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Boolean)
], User.prototype, "requiresSubscription", void 0);
__decorate([
    (0, typeorm_1.Column)('simple-array', { nullable: true }),
    __metadata("design:type", Array)
], User.prototype, "workDays", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], User.prototype, "workShiftStart", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], User.prototype, "workShiftEnd", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'datetime', nullable: true }),
    __metadata("design:type", Date)
], User.prototype, "registrationDate", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => equipamento_entity_1.Equipamento, (equipamento) => equipamento.user),
    __metadata("design:type", Array)
], User.prototype, "equipamentos", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => chamado_entity_1.Chamado, (chamado) => chamado.user),
    __metadata("design:type", Array)
], User.prototype, "chamados", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => colaborador_entity_1.Colaborador, (registro) => registro.user),
    __metadata("design:type", Array)
], User.prototype, "registrosColaborador", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => registroColaborador_entity_1.RegistrosColaborador, (registro) => registro.empresa),
    __metadata("design:type", Array)
], User.prototype, "colaboradoresDaEmpresa", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => despesas_entity_1.Despesas, (despesa) => despesa.user),
    __metadata("design:type", Array)
], User.prototype, "despesas", void 0);
exports.User = User = __decorate([
    (0, typeorm_1.Entity)()
], User);
//# sourceMappingURL=user.entity.js.map