"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChamadoService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const chamado_entity_1 = require("./entities/chamado.entity");
const event_emitter_1 = require("@nestjs/event-emitter");
const equipamento_entity_1 = require("../equipamento/entities/equipamento.entity");
const resposta_checklist_entity_1 = require("./entities/resposta-checklist.entity");
const user_entity_1 = require("../user/entities/user.entity");
const user_role_enum_1 = require("../user/user-role.enum");
const equipamento_role_enum_1 = require("../equipamento/equipamento-role.enum");
const resposta_checklist_tecnico_entity_1 = require("./entities/resposta-checklist-tecnico.entity");
const client_s3_1 = require("@aws-sdk/client-s3");
const checklist_gateway_1 = require("./checklist.gateway");
const stream_1 = require("stream");
let ChamadoService = class ChamadoService {
    chamadoRepository;
    eventEmitter;
    equipamentoRepository;
    respostaChecklistRepository;
    respostaChecklistTecnicoRepository;
    checklistGateway;
    userRepository;
    s3;
    constructor(chamadoRepository, eventEmitter, equipamentoRepository, respostaChecklistRepository, respostaChecklistTecnicoRepository, checklistGateway, userRepository) {
        this.chamadoRepository = chamadoRepository;
        this.eventEmitter = eventEmitter;
        this.equipamentoRepository = equipamentoRepository;
        this.respostaChecklistRepository = respostaChecklistRepository;
        this.respostaChecklistTecnicoRepository = respostaChecklistTecnicoRepository;
        this.checklistGateway = checklistGateway;
        this.userRepository = userRepository;
        this.s3 = new client_s3_1.S3Client({
            region: process.env.AWS_S3_REGION,
        });
    }
    async abrir(dto, equipamentoId, currentUser, files) {
        if (currentUser.role === user_role_enum_1.UserRole.COMMON_USER) {
            const equipamento = await this.equipamentoRepository.findOne({
                where: { id: equipamentoId, user: { id: currentUser.id } },
            });
            if (!equipamento) {
                throw new common_1.ForbiddenException('Equipamento não encontrado ou não pertence a este usuário.');
            }
            const chamadoAndamento = await this.chamadoRepository.findOne({
                relations: ['equipamento'],
                where: {
                    status: (0, typeorm_2.In)(['Aberto', 'Em andamento', 'Pendente']),
                    equipamento: { id: equipamentoId },
                },
            });
            if (chamadoAndamento) {
                throw new common_1.ForbiddenException('Já existe um chamado em andamento para este equipamento.');
            }
            const novoChamado = this.chamadoRepository.create({
                equipamento: equipamento,
                tipo: dto.tipo,
                user: { id: currentUser.id },
            });
            await this.chamadoRepository.save(novoChamado);
            await this.equipamentoRepository.update(equipamentoId, {
                status: equipamento_role_enum_1.EquipamentoStatus.MANUTENCAO,
            });
            const userChecklist = this.respostaChecklistRepository.create({
                pico_energia: dto.triagemHouvePicoEnergia,
                observacao: dto.observacao,
                chamado: novoChamado,
            });
            await this.respostaChecklistRepository.save(userChecklist);
            if (files && files.length > 0) {
                try {
                    const urls = await Promise.all(files.map(async (file) => {
                        const uniqueFileName = `${Date.now()}-${file.originalname}`;
                        return await this.uploadImageToS3(file, uniqueFileName);
                    }));
                    userChecklist.urlMedia = userChecklist.urlMedia
                        ? [...userChecklist.urlMedia, ...urls]
                        : urls;
                    await this.respostaChecklistRepository.save(userChecklist);
                }
                catch (error) {
                    throw new common_1.BadRequestException('Falha ao enviar arquivos: ' + error.message);
                }
            }
            this.eventEmitter.emit('chamado.Aberto', novoChamado);
            return novoChamado;
        }
        else if (currentUser.role === user_role_enum_1.UserRole.TECHNICAL) {
            const chamado = await this.chamadoRepository.findOne({
                where: {
                    equipamento: { id: equipamentoId },
                    status: (0, typeorm_2.In)(['Pendente', 'Em andamento', 'Finalizado']),
                },
                order: { horaAbertura: 'DESC' },
                relations: ['equipamento'],
            });
            if (!dto.checklistsTecnico) {
                throw new common_1.BadRequestException('nao criou o checklist tecnico');
            }
            if (dto.checklistsTecnico && chamado) {
                await Promise.all(dto.checklistsTecnico.map(async (item) => {
                    const newChecklistItem = this.respostaChecklistTecnicoRepository.create({
                        nomeChecklist: item.nomeChecklist,
                        estado: item.estado,
                        observacao: item.observacao,
                        operacional: item.operacional,
                        chamado: chamado,
                    });
                    if (item.nomeArquivoReferencia && files && files.length > 0) {
                        const fileMatching = files.find((file) => file.originalname === item.nomeArquivoReferencia);
                        if (fileMatching) {
                            const uniqueFileName = `${Date.now()}-${fileMatching.originalname}`;
                            newChecklistItem.urlMedia = await this.uploadImageToS3(fileMatching, uniqueFileName);
                        }
                    }
                    await this.respostaChecklistTecnicoRepository.save(newChecklistItem);
                }));
            }
            if (chamado) {
                chamado.status = 'Finalizado';
                const agora = new Date();
                chamado.horaFinalizacao = agora;
                const calc = agora.getTime() - chamado.horaAbertura.getTime();
                chamado.tempoDeRespostaMs = calc;
                chamado.tecnico = currentUser;
                await this.chamadoRepository.save(chamado);
                await this.equipamentoRepository.update(equipamentoId, {
                    status: equipamento_role_enum_1.EquipamentoStatus.DISPONIVEL,
                });
            }
            return chamado;
        }
        else {
            throw new common_1.ForbiddenException('Tipo de usuário não autorizado a abrir chamado.');
        }
    }
    async assinarChamado(chamadoId, currentUser, base64String) {
        const chamado = await this.chamadoRepository.findOne({
            where: { id: chamadoId, user: { id: currentUser.id } },
            relations: ['equipamento'],
        });
        if (!chamado) {
            throw new common_1.ForbiddenException('Chamado não encontrado');
        }
        const base64Data = base64String.replace(/^data:image\/\w+;base64,/, '');
        const buffer = Buffer.from(base64Data, 'base64');
        const fakeFile = {
            fieldname: 'file',
            originalname: `assinatura_chamado_${chamadoId}.png`,
            encoding: '7bit',
            mimetype: 'image/png',
            buffer: buffer,
            size: buffer.length,
            stream: stream_1.Readable.from(buffer),
            destination: '',
            filename: '',
            path: '',
        };
        const hoje = new Date();
        const urlAssinatura = await this.uploadImageToS3(fakeFile, `assinatura-${hoje.getTime()}`);
        await this.chamadoRepository.update(chamadoId, {
            assinatura: urlAssinatura,
            status: 'Finalizado',
            horaFinalizacao: hoje,
        });
        await this.equipamentoRepository.update(chamado.equipamento.id, {
            status: equipamento_role_enum_1.EquipamentoStatus.DISPONIVEL,
        });
        return { message: 'Chamado assinado e finalizado com sucesso' };
    }
    async findAllChamados(currentUser) {
        const query = this.chamadoRepository
            .createQueryBuilder('chamado')
            .leftJoin('chamado.equipamento', 'equipamento')
            .leftJoin('chamado.user', 'user')
            .leftJoin('chamado.tecnico', 'tecnico')
            .leftJoin('chamado.respostasChecklist', 'userChecklist')
            .select([
            'chamado.id as id',
            'chamado.status as status',
            'chamado.horaAbertura as horaAbertura',
            'chamado.horaInicioAtendimento as horaInicioAtendimento',
            'chamado.horaFinalizacao as horaFinalizacao',
            'chamado.dataMarcada AS dataMarcada',
            'chamado.tipo AS tipo',
            'chamado.atividade AS atividade',
            'chamado.assinatura AS assinatura',
            'user.name as name',
            'user.requiresSubscription as requerAssinatura',
            'user.telefone AS telefone',
            'equipamento.modeloCompressor as modeloCompressor',
            'equipamento.id as equipamentoId',
            'tecnico.name as tecnicoName',
            'tecnico.id as tecnicoId',
            'userChecklist.observacao AS observacao',
            'userChecklist.urlMedia AS urlMedia',
            'userChecklist.pico_energia AS picoEnergia',
        ]);
        if (currentUser.role === user_role_enum_1.UserRole.COMMON_USER) {
            query.where('chamado.userId = :userId', { userId: currentUser.id });
        }
        else if (currentUser.role === user_role_enum_1.UserRole.TECHNICAL) {
            query.where('chamado.tecnicoId = :tecnicoId', {
                tecnicoId: currentUser.id,
            });
        }
        return query.orderBy('chamado.horaAbertura', 'DESC').getRawMany();
    }
    async findOne(id) {
        const chamado = await this.chamadoRepository
            .createQueryBuilder('chamado')
            .leftJoin('chamado.equipamento', 'equipamento')
            .leftJoin('chamado.user', 'user')
            .leftJoin('chamado.tecnico', 'tecnico')
            .leftJoin('chamado.respostasChecklist', 'respostasChecklist')
            .leftJoin('chamado.respostasChecklistTecnico', 'respostasChecklistTecnico')
            .where('chamado.id = :id', { id })
            .select('chamado.id', 'id')
            .addSelect('chamado.status', 'status')
            .addSelect('chamado.horaAbertura', 'horaAbertura')
            .addSelect('chamado.horaInicioAtendimento', 'horaInicioAtendimento')
            .addSelect('chamado.horaFinalizacao', 'horaFinalizacao')
            .addSelect('user.name', 'name')
            .addSelect('tecnico.id', 'tecnicoId')
            .addSelect('tecnico.name', 'tecnicoName')
            .addSelect('equipamento.modeloCompressor', 'modeloCompressor')
            .addSelect('equipamento.id', 'equipamentoId')
            .addSelect('respostasChecklist.id', 'respostasChecklistId')
            .addSelect('respostasChecklist.pico_energia', 'pico_energia')
            .addSelect('respostasChecklist.observacao', 'observacao')
            .addSelect('respostasChecklist.urlMedia', 'urlMedia')
            .addSelect('respostasChecklistTecnico.id', 'respostasChecklistTecnicoId')
            .addSelect('respostasChecklistTecnico.nomeChecklist', 'nomeChecklist')
            .addSelect('respostasChecklistTecnico.estado', 'estado')
            .addSelect('respostasChecklistTecnico.observacao', 'observacao')
            .addSelect('respostasChecklistTecnico.urlMedia', 'urlMedia')
            .addSelect('respostasChecklistTecnico.operacional', 'operacional')
            .getRawOne();
        return chamado;
    }
    async findAllOfUser(userId) {
        const chamadosCliente = await this.chamadoRepository.find({
            where: { user: { id: userId } },
            relations: { tecnico: true, user: true },
        });
        if (chamadosCliente.length > 0) {
            return chamadosCliente.map((c) => ({
                ...c,
                tecnico: c.tecnico
                    ? {
                        id: c.tecnico.id,
                        nome: c.tecnico.name,
                    }
                    : null,
                user: c.user
                    ? {
                        id: c.user.id,
                        user: c.user.name,
                    }
                    : null,
            }));
        }
        const chamadosTecnico = await this.chamadoRepository.find({
            where: { tecnico: { id: userId } },
            relations: { tecnico: true, user: true },
        });
        if (chamadosTecnico.length > 0) {
            return chamadosTecnico.map((c) => ({
                ...c,
                tecnico: c.tecnico
                    ? {
                        id: c.tecnico.id,
                        nome: c.tecnico.name,
                    }
                    : null,
                user: c.user
                    ? {
                        id: c.user.id,
                        user: c.user.name,
                    }
                    : null,
            }));
        }
        throw new common_1.BadRequestException('Nenhum chamado encontrado para este usuário');
    }
    async atribuirTecnico(chamadoID, tecnicoID, date) {
        const existChamado = await this.chamadoRepository.findOne({
            where: { id: chamadoID },
        });
        const existTecnico = await this.userRepository.findOne({
            where: { id: tecnicoID },
        });
        if (!existChamado) {
            throw new common_1.ForbiddenException('Chamado não encontrado');
        }
        if (!existTecnico || existTecnico.role !== user_role_enum_1.UserRole.TECHNICAL) {
            throw new common_1.ForbiddenException('Técnico não encontrado');
        }
        existChamado.tecnico = existTecnico;
        existChamado.dataMarcada = date;
        await this.chamadoRepository.save(existChamado);
        return existChamado;
    }
    async atualizarPorCheck(equipamentoId, dto, currentUser, files) {
        const chamado = await this.chamadoRepository.findOne({
            where: {
                equipamento: { id: equipamentoId },
                tecnico: { id: currentUser.id },
                status: (0, typeorm_2.In)(['Pendente', 'Em andamento']),
            },
        });
        if (!chamado) {
            throw new common_1.ForbiddenException('Chamado não encontrado ou sem permissão.');
        }
        if (dto.checklistsTecnico) {
            for (const itemDto of dto.checklistsTecnico) {
                let checklistItem = await this.respostaChecklistTecnicoRepository.findOne({
                    where: {
                        chamado: { id: chamado.id },
                        nomeChecklist: itemDto.nomeChecklist,
                    },
                });
                if (!checklistItem) {
                    checklistItem = this.respostaChecklistTecnicoRepository.create({
                        chamado,
                        nomeChecklist: itemDto.nomeChecklist,
                        operacional: itemDto.operacional ?? false,
                        observacao: itemDto.observacao ?? '',
                        urlMedia: undefined,
                    });
                }
                else {
                    checklistItem.operacional =
                        itemDto.operacional ?? checklistItem.operacional;
                    if (itemDto.observacao !== undefined) {
                        checklistItem.observacao = itemDto.observacao;
                    }
                }
                if (files && files.length > 0 && itemDto.nomeArquivoReferencia) {
                    const novasUrls = [];
                    const referencias = Array.isArray(itemDto.nomeArquivoReferencia)
                        ? itemDto.nomeArquivoReferencia
                        : [itemDto.nomeArquivoReferencia];
                    const arquivosDoItem = files.filter((file) => referencias.includes(file.originalname));
                    for (const file of arquivosDoItem) {
                        const uniqueFileName = `${Date.now()}-${file.originalname}`;
                        const url = await this.uploadImageToS3(file, uniqueFileName);
                        novasUrls.push(url);
                    }
                    if (novasUrls.length > 0) {
                        const urlsAntigas = checklistItem.urlMedia
                            ? checklistItem.urlMedia.split(',')
                            : [];
                        checklistItem.urlMedia = [...urlsAntigas, ...novasUrls].join(',');
                    }
                }
                await this.respostaChecklistTecnicoRepository.save(checklistItem);
            }
        }
        this.checklistGateway.enviarAtualizacao(equipamentoId);
        return await this.chamadoRepository.findOne({
            where: { id: chamado.id },
            relations: ['respostasChecklistTecnico'],
        });
    }
    async finalizarChamado(equipamentoId, currentUser, resumoData) {
        const existChamado = await this.chamadoRepository.findOne({
            where: {
                equipamento: { id: equipamentoId },
                tecnico: { id: currentUser.id },
                status: 'Em andamento',
            },
            relations: ['user'],
        });
        if (!existChamado) {
            throw new common_1.BadRequestException('chamado não achado');
        }
        if (existChamado.user.requiresSubscription) {
            const resumo = await this.respostaChecklistTecnicoRepository.create({
                chamado: { id: existChamado.id },
                nomeChecklist: 'Resumo',
                observacao: resumoData,
            });
            await this.respostaChecklistTecnicoRepository.save(resumo);
            this.chamadoRepository.update(existChamado?.id, {
                horaFinalizacao: new Date(),
            });
            return 'finalizado com sucesso, usuario precisa assinar';
        }
        const resumo = await this.respostaChecklistTecnicoRepository.create({
            chamado: { id: existChamado.id },
            nomeChecklist: 'Resumo',
            observacao: resumoData,
        });
        await this.respostaChecklistTecnicoRepository.save(resumo);
        this.chamadoRepository.update(existChamado?.id, {
            status: 'Finalizado',
            horaFinalizacao: new Date(),
        });
        const equipamento = await this.equipamentoRepository.findOne({
            where: { id: equipamentoId },
        });
        if (equipamento) {
            equipamento.status = equipamento_role_enum_1.EquipamentoStatus.DISPONIVEL;
            await this.equipamentoRepository.save(equipamento);
        }
    }
    async itensModal(equipamentoId) {
        const chamado = await this.chamadoRepository.findOne({
            where: {
                equipamento: { id: equipamentoId },
                status: (0, typeorm_2.In)(['Pendente', 'Em andamento']),
            },
        });
        if (!chamado) {
            throw new common_1.NotFoundException(`Nenhum chamado ativo encontrado para o equipamento com ID ${equipamentoId}.`);
        }
        return this.respostaChecklistTecnicoRepository.find({
            where: { chamado: { id: chamado.id } },
        });
    }
    async getCheckListTeck(equipamentoId) {
        const chamado = await this.chamadoRepository.findOne({
            where: { equipamento: { id: equipamentoId } },
            relations: ['respostasChecklistTecnico'],
            order: {
                horaAbertura: 'DESC',
            },
        });
        if (!chamado) {
            throw new common_1.NotFoundException('Nemhum chamado encontrado para este equipamento');
        }
        await this.equipamentoRepository.update(equipamentoId, {
            status: equipamento_role_enum_1.EquipamentoStatus.MANUTENCAO,
        });
        return chamado.respostasChecklistTecnico;
    }
    async detalhesOsCliente(CurrentUser, osID) {
        const chamado = await this.chamadoRepository.findOne({
            where: {
                id: osID,
            },
            relations: ['equipamento', 'user', 'tecnico', 'respostasChecklist'],
            order: {
                horaAbertura: 'DESC',
            },
        });
        if (!chamado) {
            throw new common_1.NotFoundException('Nenhum chamado encontrado para este equipamento.');
        }
        return {
            id: chamado.id,
            status: chamado.status,
            horaAbertura: chamado.horaAbertura,
            razaoSocial: chamado.user?.name,
            modeloCompressor: chamado.equipamento?.modeloCompressor,
            tecnicoName: chamado.tecnico?.name,
            midiasUser: (chamado.respostasChecklist || []).flatMap((r) => r.urlMedia, []),
            observacaoUser: (chamado.respostasChecklist || []).flatMap((r) => r.observacao || []),
            picoEnergia: (chamado.respostasChecklist || []).flatMap((r) => r.pico_energia || []),
            checklistsTecnico: (chamado.respostasChecklistTecnico || []).map((r) => ({
                nome: r.nomeChecklist,
                estado: r.estado,
                observacao: r.observacao,
                urlMedia: r.urlMedia,
                operacional: r.operacional,
            })),
        };
    }
    async timeLine(CurrentUser, osId) {
        const chamadoAtivo = await this.chamadoRepository.findOne({
            where: {
                id: osId,
            },
            relations: [
                'respostasChecklist',
                'respostasChecklistTecnico',
                'tecnico',
            ],
            order: {
                horaAbertura: 'DESC',
            },
        });
        if (!chamadoAtivo) {
            throw new common_1.NotFoundException('Nenhum chamado ativo encontrado para este equipamento.');
        }
        const timelineData = {
            id: chamadoAtivo.id,
            status: chamadoAtivo.status,
            tipo: chamadoAtivo.tipo,
            horaAbertura: chamadoAtivo.horaAbertura,
            horaFinalizacao: chamadoAtivo.horaFinalizacao,
            equipamento: chamadoAtivo.equipamento
                ? {
                    id: chamadoAtivo.equipamento.id,
                    modelo: chamadoAtivo.equipamento.modeloCompressor,
                }
                : null,
            tecnico: chamadoAtivo.tecnico
                ? {
                    id: chamadoAtivo.tecnico.id,
                    nome: chamadoAtivo.tecnico.name,
                }
                : null,
            respostasCliente: chamadoAtivo.respostasChecklist.map((r) => ({
                observacao: r.observacao,
                midias: r.urlMedia,
            })),
            respostasTecnico: chamadoAtivo.respostasChecklistTecnico.map((r) => ({
                nome: r.nomeChecklist,
                estado: r.estado,
                observacao: r.observacao,
                operacional: r.operacional,
                midia: r.urlMedia,
            })),
        };
        return timelineData;
    }
    async deletarOs(osId) {
        const existOs = await this.chamadoRepository.findOne({
            where: { id: osId },
            relations: ['equipamento'],
        });
        if (!existOs) {
            throw new common_1.ForbiddenException('Chamado não encontrado');
        }
        try {
            const equipamento = existOs.equipamento;
            await this.chamadoRepository.remove(existOs);
            if (equipamento && equipamento.id) {
                await this.equipamentoRepository.update(equipamento.id, {
                    status: equipamento_role_enum_1.EquipamentoStatus.DISPONIVEL,
                });
            }
            return { message: 'Chamado deletado com sucesso.' };
        }
        catch (error) {
            console.error('Erro ao deletar chamado:', error);
            throw new common_1.BadRequestException('Falha ao deletar chamado: ' + error.message);
        }
    }
    async uploadImageToS3(file, fileName) {
        const region = process.env.AWS_S3_REGION;
        const agora = new Date();
        const uploadParams = new client_s3_1.PutObjectCommand({
            Bucket: process.env.AWS_S3_BUCKET,
            Key: fileName + agora.getHours() + agora.getMinutes() + agora.getSeconds(),
            Body: file.buffer,
            ContentType: file.mimetype,
        });
        try {
            await this.s3.send(uploadParams);
            const url = `https://${process.env.AWS_S3_BUCKET}.s3.${region}.amazonaws.com/${fileName + agora.getHours() + agora.getMinutes() + agora.getSeconds()}`;
            return url;
        }
        catch (err) {
            console.error('Erro ao enviar para S3:', err);
            throw new common_1.BadRequestException('Erro ao enviar arquivo para o S3');
        }
    }
};
exports.ChamadoService = ChamadoService;
exports.ChamadoService = ChamadoService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(chamado_entity_1.Chamado)),
    __param(2, (0, typeorm_1.InjectRepository)(equipamento_entity_1.Equipamento)),
    __param(3, (0, typeorm_1.InjectRepository)(resposta_checklist_entity_1.RespostaChecklist)),
    __param(4, (0, typeorm_1.InjectRepository)(resposta_checklist_tecnico_entity_1.RespostaChecklistTecnico)),
    __param(6, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        event_emitter_1.EventEmitter2,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        checklist_gateway_1.ChecklistGateway,
        typeorm_2.Repository])
], ChamadoService);
//# sourceMappingURL=chamado.service.js.map