"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chamado = void 0;
const equipamento_entity_1 = require("../../equipamento/entities/equipamento.entity");
const typeorm_1 = require("typeorm");
const resposta_checklist_entity_1 = require("./resposta-checklist.entity");
const resposta_checklist_tecnico_entity_1 = require("./resposta-checklist-tecnico.entity");
const class_validator_1 = require("class-validator");
const user_entity_1 = require("../../user/entities/user.entity");
const colaborador_entity_1 = require("../../colaborador/entities/colaborador.entity");
let Chamado = class Chamado {
    id;
    tipo;
    status;
    horaAbertura;
    horaInicioAtendimento;
    horaFinalizacao;
    tempoDeRespostaMs;
    dataMarcada;
    assinatura;
    atividade;
    user;
    tecnico;
    equipamento;
    respostasChecklist;
    respostasChecklistTecnico;
    pontoColaborador;
};
exports.Chamado = Chamado;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Chamado.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 'Corretivo' }),
    __metadata("design:type", String)
], Chamado.prototype, "tipo", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 'Aberto' }),
    __metadata("design:type", String)
], Chamado.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Chamado.prototype, "horaAbertura", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", Date)
], Chamado.prototype, "horaInicioAtendimento", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", Date)
], Chamado.prototype, "horaFinalizacao", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", Number)
], Chamado.prototype, "tempoDeRespostaMs", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'datetime', nullable: true }),
    __metadata("design:type", Date)
], Chamado.prototype, "dataMarcada", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Chamado.prototype, "assinatura", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Chamado.prototype, "atividade", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.User, (user) => user.chamados),
    __metadata("design:type", user_entity_1.User)
], Chamado.prototype, "user", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.User, { nullable: true }),
    __metadata("design:type", user_entity_1.User)
], Chamado.prototype, "tecnico", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, typeorm_1.ManyToOne)(() => equipamento_entity_1.Equipamento, (equipamento) => equipamento.chamados),
    (0, typeorm_1.JoinColumn)({ name: 'equipamentoId' }),
    __metadata("design:type", equipamento_entity_1.Equipamento)
], Chamado.prototype, "equipamento", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => resposta_checklist_entity_1.RespostaChecklist, (resposta) => resposta.chamado),
    __metadata("design:type", Array)
], Chamado.prototype, "respostasChecklist", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => resposta_checklist_tecnico_entity_1.RespostaChecklistTecnico, (resposta) => resposta.chamado),
    __metadata("design:type", Array)
], Chamado.prototype, "respostasChecklistTecnico", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => colaborador_entity_1.Colaborador, (colaborador) => colaborador.chamado),
    __metadata("design:type", colaborador_entity_1.Colaborador)
], Chamado.prototype, "pontoColaborador", void 0);
exports.Chamado = Chamado = __decorate([
    (0, typeorm_1.Entity)()
], Chamado);
//# sourceMappingURL=chamado.entity.js.map