import { ColaboradorService } from './colaborador.service';
import { CreateColaboradorDto } from './dto/create-colaborador.dto';
import { UpdateColaboradorDto } from './dto/update-colaborador.dto';
import { User } from 'src/user/entities/user.entity';
export declare class ColaboradorController {
    private readonly colaboradorService;
    constructor(colaboradorService: ColaboradorService);
    create(currentUser: User): Promise<import("./entities/colaborador.entity").Colaborador | undefined>;
    registroColaborador(id: string, data: string, file?: Express.Multer.File): Promise<import("./entities/registroColaborador.entity").RegistrosColaborador>;
    pontoColaborador(currentUser: User): Promise<import("./entities/colaborador.entity").Colaborador[]>;
    despesas(data: string, currentUser: User, file?: Express.Multer.File): Promise<import("./entities/despesas.entity").Despesas>;
    iniciarVisitaAgendada(currentUser: User, chamadoId: string): Promise<void>;
    criarVisita(tecnicoId: string, equipamentoid: string, createColaboradorDto: CreateColaboradorDto): Promise<import("../chamado/entities/chamado.entity").Chamado>;
    atualizarVisita(chamadoId: string, tecnicoId: string, equipamentoid: string, UpdateColaboradorDto: CreateColaboradorDto): Promise<import("../chamado/entities/chamado.entity").Chamado>;
    getVisitaAgendada(currentUser: User): Promise<{
        user: string;
        email: string;
        empresa: string;
        id: number;
        atividade: string;
        dataMarcada: Date;
        status: string;
        tipo: string;
        equipamento: import("../equipamento/entities/equipamento.entity").Equipamento;
    }[] | {
        empresa: string;
        id: number;
        atividade: string;
        dataMarcada: Date;
        status: string;
        tipo: string;
        user: User;
        equipamento: import("../equipamento/entities/equipamento.entity").Equipamento;
    }[]>;
    getDespesas(currentUser: User): Promise<import("./entities/despesas.entity").Despesas[] | {
        user: string;
        email: string;
        id: number;
        data: Date;
        tipo: string;
        valor: number;
        status: string;
        urlArquivo: string;
    }[]>;
    aprovarDespesa(id: string): Promise<import("./entities/despesas.entity").Despesas>;
    rejeitarDespesa(id: string): Promise<import("./entities/despesas.entity").Despesas>;
    linhaTempo(id: string): Promise<import("./entities/colaborador.entity").Colaborador | null>;
    historicoPonto(currentUser: User): Promise<import("./entities/colaborador.entity").Colaborador[]>;
    historicoPontoAdmin(id: string): Promise<{
        user: User | null;
        resultado: any;
    }>;
    findAll(date?: string): Promise<any>;
    findOne(id: string): Promise<import("./entities/colaborador.entity").Colaborador | null>;
    update(id: string, updateColaboradorDto: UpdateColaboradorDto): Promise<import("typeorm").UpdateResult>;
    remove(id: string): Promise<import("typeorm").DeleteResult>;
}
