"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColaboradorController = void 0;
const common_1 = require("@nestjs/common");
const colaborador_service_1 = require("./colaborador.service");
const create_colaborador_dto_1 = require("./dto/create-colaborador.dto");
const update_colaborador_dto_1 = require("./dto/update-colaborador.dto");
const passport_1 = require("@nestjs/passport");
const roles_guard_1 = require("../auth/guards/roles.guard");
const current_user_decorator_1 = require("../auth/decorators/current-user.decorator");
const user_entity_1 = require("../user/entities/user.entity");
const user_role_enum_1 = require("../user/user-role.enum");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = __importDefault(require("multer"));
let ColaboradorController = class ColaboradorController {
    colaboradorService;
    constructor(colaboradorService) {
        this.colaboradorService = colaboradorService;
    }
    create(currentUser) {
        return this.colaboradorService.create(currentUser);
    }
    registroColaborador(id, data, file) {
        const updateColaboradorDto = JSON.parse(data);
        return this.colaboradorService.registroColaborador(+id, updateColaboradorDto, file);
    }
    pontoColaborador(currentUser) {
        return this.colaboradorService.pontoColaborador(currentUser);
    }
    despesas(data, currentUser, file) {
        const createDespesasDto = JSON.parse(data);
        return this.colaboradorService.despesas(createDespesasDto, currentUser, file);
    }
    iniciarVisitaAgendada(currentUser, chamadoId) {
        return this.colaboradorService.iniciarVisitaAgendada(currentUser, +chamadoId);
    }
    criarVisita(tecnicoId, equipamentoid, createColaboradorDto) {
        return this.colaboradorService.criarVisita(+tecnicoId, +equipamentoid, createColaboradorDto);
    }
    atualizarVisita(chamadoId, tecnicoId, equipamentoid, UpdateColaboradorDto) {
        return this.colaboradorService.atualizarVisita(+chamadoId, +tecnicoId, +equipamentoid, UpdateColaboradorDto);
    }
    getVisitaAgendada(currentUser) {
        return this.colaboradorService.getVisitaAgendada(currentUser);
    }
    getDespesas(currentUser) {
        return this.colaboradorService.getDespesas(currentUser);
    }
    aprovarDespesa(id) {
        return this.colaboradorService.aprovarDespesa(+id);
    }
    rejeitarDespesa(id) {
        return this.colaboradorService.rejeitarDespesa(+id);
    }
    linhaTempo(id) {
        return this.colaboradorService.linhaTempo(+id);
    }
    historicoPonto(currentUser) {
        return this.colaboradorService.historicoPonto(currentUser);
    }
    historicoPontoAdmin(id) {
        return this.colaboradorService.historicoPontoAdmin(+id);
    }
    findAll(date) {
        return this.colaboradorService.findAll(date);
    }
    findOne(id) {
        return this.colaboradorService.findOne(+id);
    }
    update(id, updateColaboradorDto) {
        return this.colaboradorService.update(+id, updateColaboradorDto);
    }
    remove(id) {
        return this.colaboradorService.remove(+id);
    }
};
exports.ColaboradorController = ColaboradorController;
__decorate([
    (0, common_1.Post)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('/registro-colaborador/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', {
        storage: multer_1.default.memoryStorage(),
    })),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)('data')),
    __param(2, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Object]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "registroColaborador", null);
__decorate([
    (0, common_1.Get)('/entrada-saida'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "pontoColaborador", null);
__decorate([
    (0, common_1.Post)('/despesas'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', {
        storage: multer_1.default.memoryStorage(),
    })),
    __param(0, (0, common_1.Body)('data')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __param(2, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, user_entity_1.User, Object]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "despesas", null);
__decorate([
    (0, common_1.Post)('visita-agendada/:chamadoId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_1.Param)('chamadoId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User, String]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "iniciarVisitaAgendada", null);
__decorate([
    (0, common_1.Post)('agendar/:tecnicoId/:equipamentoId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Param)('tecnicoId')),
    __param(1, (0, common_1.Param)('equipamentoId')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, create_colaborador_dto_1.CreateColaboradorDto]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "criarVisita", null);
__decorate([
    (0, common_1.Patch)('atualizar/agenda/:chamadoId/:tecnicoId/:equipamentoId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Param)('chamadoId')),
    __param(1, (0, common_1.Param)('tecnicoId')),
    __param(2, (0, common_1.Param)('equipamentoId')),
    __param(3, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, create_colaborador_dto_1.CreateColaboradorDto]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "atualizarVisita", null);
__decorate([
    (0, common_1.Get)('/visita-agendada'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL, user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "getVisitaAgendada", null);
__decorate([
    (0, common_1.Get)('/despesas'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL, user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "getDespesas", null);
__decorate([
    (0, common_1.Patch)('/aprova-despesas/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "aprovarDespesa", null);
__decorate([
    (0, common_1.Patch)('/rejeita-despesas/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "rejeitarDespesa", null);
__decorate([
    (0, common_1.Get)('linha-tempo/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "linhaTempo", null);
__decorate([
    (0, common_1.Get)('historico-ponto/'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "historicoPonto", null);
__decorate([
    (0, common_1.Get)('historico-ponto-admin/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "historicoPontoAdmin", null);
__decorate([
    (0, common_1.Get)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Query)('date')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_colaborador_dto_1.UpdateColaboradorDto]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ColaboradorController.prototype, "remove", null);
exports.ColaboradorController = ColaboradorController = __decorate([
    (0, common_1.Controller)('colaborador'),
    __metadata("design:paramtypes", [colaborador_service_1.ColaboradorService])
], ColaboradorController);
//# sourceMappingURL=colaborador.controller.js.map